// $Id: HNSTypedTensor.h,v 1.4 2003/03/02 17:28:38 hns Exp $
//
//  BasicData.h
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Sat Jun 15 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

// typed container i.e. variables defined by DIM statement

@interface HNSTypedTensor : NSObject {
	Class type;				// all assigned objects must be this kindOfClass
	BOOL redim;				// redim permitted (otherwise raise exception)
	NSMutableArray *rho;	// dimension vector
	NSMutableArray *data;	// data vector
	int origin;				// 0..dim-1 or 1..dim index
}

- (id) initScalarForClass:(Class) class;							// define permitted class (and subclasses)
- (id) initScalar:(id) n;				// scalar of certain type
- (id) initWithDimension:(NSArray *) dim forClass:(Class) class;	// array with class

- (id) initWithIndexGenerator:(int) n;	// vector initialized with NSNumber from 1..n
- (id) iota:(int) n;					// alternate name

- (void) setType:(Class) class;			// define permitted type (class and its subclasses)
- (Class) getType;

- (id) object;							// get scalar value
- (void) replaceObject:(id) val;		// set scalar value - raise exception if type is not permitted

- (NSArray *) array;					// get vector value

- (id) objectAtIndex:(unsigned) i;		// value at index (for one-dimensional tensors)
- (id) objectAtIndexList:(NSArray *) i;	// value at index vector
- (void) replaceObjectAtIndexList:(NSArray *) i withObject:(id) obj;	// set value - raise exception if type is not permitted

- (NSArray *) rho;						// dimension vector - made of NSNumber
- (void) setRho:(NSArray *) s;			// redim

- (unsigned) rhorho;					// get number of dimensions
- (unsigned) count;						// total size
- (unsigned) origin;
- (void) setOrigin:(unsigned) o;

- (HNSTypedTensor *) reduce:(SEL) selector;				// apply o=[o selector:x] for all elements x - has some built-in defaults for empty reduction dependent on selector
- (HNSTypedTensor *) reduce:(SEL) selector dim:(int) d;	// same along the d'th dimension 

@end